package com.hero.objects.disads;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.ui.dialog.DisadDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Disadvantage extends GenericObject {
	
	protected String adderSeparator = ";";

    /**
     * Returns the appropriate subclass based on the XMLID attribute of the
     * passed in Element
     * 
     * @param root
     * @return
     */
    public static Disadvantage getInstance(Element root) {
        String id = XMLUtility.getValue(root, "XMLID");
        if (id == null || id.trim().length() == 0) {
            return new Disadvantage(root);
        } else if (id.trim().toUpperCase().equals("ENRAGED")) {
            return new Enraged(root);
        } else if (id.trim().toUpperCase().equals("HUNTED")) {
            return new Hunted(root);
        } else if (id.trim().toUpperCase().equals("REPUTATION")) {
            return new Reputation(root);
        } else if (id.trim().toUpperCase().equals("SUSCEPTIBILITY")) {
            return new Susceptibility(root);
        } else {
            return new Disadvantage(root);
        }
    }

    @Override
    public boolean includedInTemplate() {
        if (HeroDesigner.getInstance().getPrefs().getSources().size() > 0) {
            for (String s : HeroDesigner.getInstance().getPrefs().getSources()) {
                if (sources.contains(s)) {
                    return true;
                }
            }
            return false;
        } else {
            return true;
        }
    }

    protected Disadvantage(Element root) {
        super(root);
    }

    /**
     * Always returns false.
     */
    @Override
    public boolean allowsOtherModifiers() {
    	if (HeroDesigner.getActiveTemplate().is6E()) return true;
        return false;
    }

    /**
     * The character to use to separate Adders in the Disadvantage description.
     * Typically ";"
     * 
     * @return
     */
    public String getAdderSeparator() {
        return adderSeparator;
    }

    @Override
    public String getColumn2Output() {
        String ret = getAlias();
        ret += ": ";
        int count = 0;
        for (Modifier mod : getAssignedModifiers()) {
            count++;
            String adderString = "";
            String modString = "";
            if (count > 1) {
                modString += ", ";
            } else {
                modString = " ";
            }
            double val = mod.getTotalValue();
            for (Adder ad : mod.getAssignedAdders()) {
                if (adderString.length() > 0) {
                    adderString += ", ";
                }
                adderString += ad.getAlias();
                val -= ad.getBaseCost();
            }
            if (mod.getInput() != null && mod.getInput().trim().length() > 0) {
                if (modString.trim().length() > 0) {
                    modString += ":  ";
                }
                modString += mod.getInput();
            }
            for (Modifier mod2 : mod.getAssignedModifiers()) {
                modString += ", " + mod2.getAlias();
            }

            if (mod.getSelectedOption() != null) {
                modString += mod.getSelectedOption().getAlias();
            }
            if (adderString.trim().length() > 0) {
                if (modString.trim().length() > 0) {
                    modString += ", ";
                }
                modString += adderString;
            }
            if (modString.trim().length() > 0) {
                ret += modString;
            }
        }
        if (getInput() != null && getInput().trim().length() > 0) {
            ret += " " + getInput();
        }
        int numParens = 0;
        count = 0;
        for (Adder ad : getAvailableAdders()) {
            count++;
            if (!getAssignedAdders().contains(ad)) {
                continue;
            }
            ad = getAssignedAdders().get(getAssignedAdders().indexOf(ad));
            if (ad.isRequired() && ad.getSelectedOption() != null
                    && ad.getSelectedOption().getAlias().trim().length() > 0) {
                if (ad.getSelectedOption().getAlias().trim().startsWith("(")) {
                    ret += " ";
                    if (ad.getSelectedOption().getAlias().indexOf(")") < 0) {
                        numParens++;
                    }
                } else if (count == 1) {
                    ret += " ";
                } else if (numParens > 0) {
                    ret += getAdderSeparator() + " ";
                } else {
                    ret += ", ";
                }
                ret += ad.getSelectedOption().getAlias();
            } else if (!ad.isRequired()) {
                String alias = ad.getAlias();
                if (ad.getSelectedOption() != null) {
                    if (alias.trim().length() > 0) {
                        alias += ":  ";
                    }
                    alias += ad.getSelectedOption().getAlias();
                }
                if (ad.getInput() != null && ad.getInput().trim().length() > 0) {
                    if (alias.trim().length() > 0) {
                        alias += ":  ";
                    }
                    alias += ad.getInput();
                }
                if (alias.trim().length() == 0) {
                    continue;
                }
                if (alias.trim().startsWith("(")) {
                    ret += " ";
                    if (alias.indexOf(")") < 0) {
                        numParens++;
                    }
                } else if (count == 1) {
                    ret += " ";
                } else if (numParens > 0) {
                    ret += getAdderSeparator() + " ";
                } else {
                    ret += ", ";
                }
                ret += alias;
            }
        }
        // custom adders
        count = 0;
        for (Adder ad : getAssignedAdders()) {
            count++;
            if (getAvailableAdders().contains(ad)) {
                continue;
            }
            String alias = ad.getAlias();
            if (ad.getSelectedOption() != null) {
                if (alias.trim().length() > 0) {
                    alias += ":  ";
                }
                alias += ad.getSelectedOption().getAlias();
            }
            if (ad.getInput() != null && ad.getInput().trim().length() > 0) {
                if (alias.trim().length() > 0) {
                    alias += ":  ";
                }
                alias += ad.getInput();
            }
            if (alias.trim().length() == 0) {
                continue;
            }
            if (alias.trim().startsWith("(")) {
                ret += " ";
                if (alias.indexOf(")") < 0) {
                    numParens++;
                }
            } else if (count == 1) {
                ret += " ";
            } else if (numParens > 0) {
                ret += getAdderSeparator() + " ";
            } else {
                ret += ", ";
            }
            ret += alias;
        }

        while (numParens > 0) {
            ret += ")";
            numParens--;
        }
        if (ret.trim().endsWith(":")) {
            ret = ret.trim();
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    @Override
	protected void init(Element pElement) {
		super.init(pElement);
		String check = XMLUtility.getValue(pElement, "ADDERSEPARATOR");
        if (check != null) {
            adderSeparator = check;
        }
	}

	@Override
    public GenericDialog getDialog(boolean isNew, boolean isPower) {
        return new DisadDialog(this, isNew);
    }

    @Override
    public Element getSaveXML() {
        Element root = getGeneralSaveXML();
        root.setName("DISAD");
        return root;
    }

    @Override
    public double getTotalCost() {
        enhancerApplied = null;
        double total = getBaseCost();
        if (getLevelValue() != 0) {
            total += getLevels() / getLevelValue() * getLevelCost();
        }
        for (Adder ad : getAssignedAdders()) {
            if (ad.isRequired()) {
                total += ad.getRealCost();
            }
        }
        for (Adder ad : getAssignedAdders()) {
            if (!ad.isRequired()) {
                total += ad.getRealCost();
            }
        }
        if (total < getMinimumCost() && isMinSet()) {
            total = getMinimumCost();
        } else if (total > getMaxCost() && isMaxSet()) {
            total = getMaxCost();
        }
        return total;
    }
}